@extends('_layouts.app')

@section('content')
    <div class="container">
        <div class="card {{ $task->done ? 'border-success' : '' }}">
            <div class="card-header bg-success text-white">
                <h2>{{$task->title}}</h2>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-6">
                        @include('_widgets.postlink', [
                            'action' => ['TasksController@delete', $task->id],
                            'method' => 'DELETE',
                            'submit' => [
                                'label' => 'Törlés',
                                'confirm' => 'Biztos hogy törlöd a taskot? (A művelet nem visszavonható!)',
                                'options' => ['class' => 'btn btn-sm btn-danger']
                            ]
                         ])
                        <a href="{{route('taskEdit', $task->id)}}" class="btn btn-sm btn-warning">{{__('Szerkesztés')}}</a>
                    </div>
                    <div class="col-sm-6 text-right">
                        @if($task->done == 0)
                            @include('_widgets.postlink', [
                                'action' => ['TasksController@close', $task->id],
                                'method' => 'PATCH',
                                'submit' => [
                                    'label' => __('Kész'),
                                    'options' => ['class' => 'btn btn-lg btn-outline-info']
                                ]
                             ])
                        @else
                            <h3>Lezárva!</h3>
                        @endif
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3"><strong>Cím:</strong></div>
                    <div class="col-sm-9">{{$task->title}}</div>
                </div>
                <div class="row">
                    <div class="col-sm-3"><strong>Leírás:</strong></div>
                    <div class="col-sm-9">{{$task->description}}</div>
                </div>
                <div class="row">
                    <div class="col-sm-3"><strong>Létrehozva:</strong></div>
                    <div class="col-sm-9">{{$task->created_at}}</div>
                </div>
                <div class="row">
                    <div class="col-sm-3"><strong>Létrehozó:</strong></div>
                    <div class="col-sm-9">{{$task->creator->name}}</div>
                </div>
                @if(!$task->files->isEmpty())
                    <h3 class="mt-3 mb-2">Csatolt Fájlok</h3>
                    <ul class="list-group">
                        @foreach($task->files as $file)
                            <li class="list-group-item">
                                <div class="row">
                                    <div class="col-sm-8">{{$file->name}}</div>
                                    <div class="col-sm-4 text-right">
                                        @include('_widgets.postlink', [
                                            'action' => ['FilesController@delete', $file->id],
                                            'method' => 'DELETE',
                                            'submit' => [
                                                'label' => 'Törlés',
                                                'confirm' => 'Biztos hogy törlöd a fájlt? (A művelet nem visszavonható!)',
                                                'options' => ['class' => 'btn btn-sm btn-danger']
                                            ]
                                        ])
                                        <a href="{{url('/storage/'.$file->path.'/'.$file->name)}}" download class="btn
                                        btn-sm
                                        btn-primary">{{ __('Letöltés') }}</a>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>
    </div>
@endsection
