@extends('_layouts.app')

@section('content')
    <div class="container">
        <h2>{{__('Feladat szerkesztése')}}</h2>
        @include('_widgets.messages')
        {!! Form::open(['action' => ['TasksController@update'], 'method' => 'POST', 'enctype' => 'multipart/form-data']) !!}
        {{ Form::hidden('task_id', $task->id) }}
        <div class="row form-group align-items-center">
            <div class="col-sm-5 col-xs-6 text">{{__('Cím')}}</div>
            <div class="col-sm-7 col-xs-6 ">
                <input type="text" name="title" value="{{$task->title}}" class="form-control">
            </div>
        </div>
        <div class="row form-group align-items-center">
            <div class="col-sm-5 col-xs-6 text">Leírás:</div>
            <div class="col-sm-7 col-xs-6 ">
                <textarea name="description" class="form-control" rows="3">{{$task->description}}</textarea>
            </div>
        </div>
        <div class="form-group">
            {{Form::file('files[]', ['multiple' => true])}}
            @if(!$task->files->isEmpty())
                <h4 class="mt-4 mb-2">{{__('Eddig feltöltött fájlok')}}</h4>
                <ul class="list-group">
                    @foreach($task->files as $file)
                        <li class="list-group-item">{{$file->name}}</li>
                    @endforeach
                </ul>
            @endif
        </div>
        {{Form::hidden('_method', 'PUT')}}
        <div class="text-center">
            {{Form::submit('Mentés', ['class' => 'btn btn-success'])}}
        </div>
        {!! Form::close() !!}
    </div>
@endsection
