<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Route::get('/tasks', 'TasksController@list')->name('taskList')->middleware('auth');
Route::get('/task/create', 'TasksController@create')->name('taskCreate')->middleware('auth');
Route::post('/task/store', 'TasksController@strore')->name('taskStore')->middleware('auth');
Route::get('/task/edit/{id}', 'TasksController@edit')->name('taskEdit')->middleware('auth');
Route::put('/task/update', 'TasksController@update')->name('taskUpdate')->middleware('auth');
Route::patch('/task/change-status/{id}', 'TasksController@changeStatus')->name('taskChangeStatus')->middleware('auth');
Route::delete('/task/delete/{id}', 'TasksController@delete')->name('taskdelete')->middleware('auth');
Route::get('/task/{id}', 'TasksController@view')->name('tasksiew')->middleware('auth');