<?php

use App\Http\Controllers\Controller;
use App\Task;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TasksController extends Controller
{
    public function list()
    {
        $tasks = Task::all()->orderBy('done', 'ASC')->orderBy('created_at', 'DESC');

        return view('tasks.list')->with(compact('tasks'));
    }

    public function create()
    {
        return view('tasks.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'min:5|max:250|required',
            'description' => 'min:5|required',
            'time' => 'required',
            'files.*' => 'nullable|mimes:pdf,xml,jpg|max:5120',
        ]);

        $task = new Task();
        $task->user_id = Auth::id();
        $task->title = $request->get('title');
        $task->description = $request->get('description');
        $task->time = $request->get('time');

        $files = $request->get('files');

        dd($files);

        foreach ($files as $file){

        }

        if($task->save()){
            return redirect()->route('taskView', $task->id)->with(['success' => 'Sikeres feladat felvétel']);
        }
    }

    public function edit($id)
    {
        $task = Task::where('id', '=', $id)->first();

        return view('tasks.edit')->with(compact('task'));
    }

    public function update(Request $request)
    {
        $this->validate($request, [
            'title' => 'min:5|max:250|required',
            'description' => 'min:5|required',
            'time' => 'required',
            'files.*' => 'nullable|mimes:pdf,xml,jpg|max:5120',
        ]);

        $task = Task::where('id', '=', $request->get('task_id'))->first();
        $task = $this->_patchEntity($task, $request);

        if($task->save()){
            return redirect()->route('tasks.update')->with(['success' => 'Sikeres feladat szerkesztés']);
        }
    }

    public function close($id)
    {
        $task = Task::where('id', '=', $id)->first();

        if($task->done == 0){
            $task->done = 1;
            $msg = 'Sikeres feladat lezárás';
        } else {
            $task->done = 0;
            $msg = 'Sikeres feladat újranyitás';
        }

        if($task->save()){
            return redirect()->back()->with(['success' => $msg]);
        }
    }

    public function delete($id)
    {
        $task = Task::where('id', '=', $id);
        if($task->delete()){
            return redirect()->back()->with(['success' => 'Sikeres feladat törlés!']);
        }
    }
}