<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    /**
     * Patch data to model data if has matching data
     *
     * @param object $modelEntity
     * @param Request $request
     * @return object $entity
     */
    protected function _patchEntity($modelEntity, Request $request)
    {
        $requestData = $request->input();
        foreach ($requestData as $dataName => $dataValue) {
            if (array_key_exists($dataName, $modelEntity->getAttributes())) {
                if (is_array($dataValue)) $dataValue = json_encode($dataValue);
                $modelEntity->$dataName = $dataValue;
            }
        }

        return $modelEntity;
    }
}
