<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Route::get('/tasks', 'TasksController@list')->name('taskList')->middleware('auth');
Route::get('/task/create', 'TasksController@create')->name('taskCreate')->middleware('auth');
Route::post('/task/store', 'TasksController@store')->name('taskStore')->middleware('auth');
Route::get('/task/edit/{id}', 'TasksController@edit')->name('taskEdit')->middleware('auth');
Route::put('/task/update', 'TasksController@update')->name('taskUpdate')->middleware('auth');
Route::patch('/task/close/{id}', 'TasksController@close')->name('taskClose')->middleware('auth');
Route::delete('/task/delete/{id}', 'TasksController@delete')->name('taskdelete')->middleware('auth');
Route::get('/task/hide', 'TasksController@hide')->name('taskHide')->middleware('auth');
Route::get('/task/{id}', 'TasksController@view')->name('taskView')->middleware('auth');

Route::delete('/file/delete/{id}', 'FilesController@delete')->name('fileDelete')->middleware('auth');