@extends('_layouts.app')

@section('content')
    <div class="container">
        <h2>{{__('Új feladat létrehozása')}}</h2>
        @include('_widgets.messages')
        {!! Form::open(['action' => ['TasksController@store'], 'method' => 'POST', 'enctype' => 'multipart/form-data']) !!}
        <div class="row form-group align-items-center">
            <div class="col-sm-5 col-xs-6 text">{{__('Cím')}}</div>
            <div class="col-sm-7 col-xs-6 ">
                <input type="text" name="title" class="form-control">
            </div>
        </div>
        <div class="row form-group align-items-center">
            <div class="col-sm-5 col-xs-6 text">Leírás:</div>
            <div class="col-sm-7 col-xs-6 ">
                <textarea name="description" class="form-control" rows="3"></textarea>
            </div>
        </div>
        <div class="form-group">
            {{Form::file('files[]', ['multiple' => true])}}
        </div>
        {{Form::hidden('_method', 'POST')}}
        <div class="text-center">
            {{Form::submit('Mentés', ['class' => 'btn btn-success'])}}
        </div>
        {!! Form::close() !!}
    </div>
@endsection
