@extends('_layouts.app')

@section('content')
    <div class="container">
        <div class="text-right">
            <a href="{{route('taskCreate')}}" class="btn btn-primary mb-2">{{__('Új feladat')}}</a>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <a href="{{route('taskHide')}}" class="btn btn-outline-info">Lezártak mutatása / elrejtése</a>
            </div>
        </div>
        @include('_widgets.search')
        <table id="mytable" class="table table-sm">
            <thead>
            <tr>
                <th>{{ __('Cím') }}</th>
                <th colspan="2">{{ __('Létrehozva')}}</th>
                <th colspan="2">{{ __('Lezárva')}}</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            @foreach($tasks as $task)
                <tr class="{{$task->done ? 'table-success' : ''}}">
                    <td class="align-middle">{{$task->title}}</td>
                    <td class="align-middle">{{Carbon::parse($task->created_at)->diffForHumans()}}</td>
                    <td class="align-middle">{{$task->created_at}}</td>
                    <td class="align-middle">{{$task->done ? Carbon::parse($task->done_date)->diffForHumans() : '-'}}</td>
                    <td class="align-middle">{{$task->done_date}}</td>
                    <td class="text-right align-middle">
                        <a href="{{route('taskView', $task->id)}}"
                           class="btn btn-sm btn-outline-primary">{{__('Megtekintés')}}</a>
                        <a href="{{route('taskEdit', $task->id)}}"
                           class="btn btn-sm btn-outline-warning">{{__('Szerkesztés')}}</a>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection
