<?php

namespace App\Http\Controllers;

use App\File;
use Illuminate\Support\Facades\Storage;

class FilesController extends Controller
{
    /**
     * Files delete
     *
     * @param $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function delete($id)
    {
        $file = File::where('id', '=', $id)->first();
        Storage::delete('public/' . $file->path . '/' . $file->name);

        if ($file->delete()) {
            return redirect()->route('taskView', $file->task_id)->with(['success' => 'Sikeres fájl törlés törlés!']);
        }
    }
}